#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
using namespace std;

typedef pair<long long, long long> Tacka;
long long vektorskiProizvod(const Tacka& O, const Tacka& A, const Tacka& B) 
{
    return (A.first - O.first) * (B.second - O.second) - (A.second - O.second) * (B.first - O.first);
}
vector<Tacka> konveksniOmotac(vector<Tacka> tacke) 
{
    int n = tacke.size();
    if (n < 3) return tacke;
    sort(tacke.begin(), tacke.end());
    vector<Tacka> donjaGranica, gornjaGranica;
    for (int i = 0; i < n; i++) 
    {
        while (donjaGranica.size() >= 2 && vektorskiProizvod(donjaGranica[donjaGranica.size() - 2], donjaGranica[donjaGranica.size() - 1], tacke[i]) <= 0) 
        {
            donjaGranica.pop_back();
        }
        donjaGranica.push_back(tacke[i]);
    }
    for (int i = n - 1; i >= 0; i--) 
    {
        while (gornjaGranica.size() >= 2 && vektorskiProizvod(gornjaGranica[gornjaGranica.size() - 2], gornjaGranica[gornjaGranica.size() - 1], tacke[i]) <= 0) 
        {
            gornjaGranica.pop_back();
        }
        gornjaGranica.push_back(tacke[i]);
    }
    donjaGranica.pop_back();
    gornjaGranica.pop_back();
    donjaGranica.insert(donjaGranica.end(), gornjaGranica.begin(), gornjaGranica.end());
    return donjaGranica;
}
long long povrsinaPoligona(const vector<Tacka>& poligon) 
{
    int n = poligon.size();
    long long povrsina = 0;
    for (int i = 0; i < n; i++) 
    {
        long long x1 = poligon[i].first, y1 = poligon[i].second;
        long long x2 = poligon[(i + 1) % n].first, y2 = poligon[(i + 1) % n].second;
        povrsina += x1 * y2 - x2 * y1;
    }
    return abs(povrsina);
}

long long resenje(const vector<Tacka>& tacke) 
{
    int n = tacke.size();
        vector<Tacka> puniOmotac = konveksniOmotac(tacke);
    long long minimalnaPovrsina = povrsinaPoligona(puniOmotac);
    for (int i = 0; i < n; i++) 
        {
        vector<Tacka> smanjeneTacke;
        for (int j = 0; j < n; j++) {
            if (j != i) smanjeneTacke.push_back(tacke[j]);
        }
        vector<Tacka> omotac = konveksniOmotac(smanjeneTacke);
        minimalnaPovrsina = min(minimalnaPovrsina, povrsinaPoligona(omotac));
    }
    return minimalnaPovrsina / 2;
}

int main() {
    int n;
    cin >> n;
    vector<Tacka> tacke(n);

    for (int i = 0; i < n; i++) 
    {
        cin >> tacke[i].first >> tacke[i].second;
    }
    cout << resenje(tacke) << endl;
    return 0;
}